import Foundation
import OtrnLibrary

func readOTRNExample() {
    print("--- OTRN Read Example Start ---")
    
    do {
        let documentRead = try OtrnDocument.read(from: filePath)
        
        print("\n--- Verification of Loaded Data ---")
        print("Loaded Project Name: \(documentRead.metadata.project ?? "N/A")")
        print("Sequence Notes Count: \(documentRead.sequence.notes.count)")
        
        let firstNote = documentRead.sequence.notes.first
        if let note = firstNote {
            print("\n==============================")
            // Required Attributes
            print("ID: \(note.noteId)")
            print("Time (s): \(note.time)")
            print("Comment: \(note.comment)")
            
            // Optional Timecode Attributes
            print("Timecode: \(note.timecode ?? "N/A")")
            print("Frame: \(note.frame.map { String($0) } ?? "N/A")")
            
            // Optional Range Marker Attributes
            print("Is Range: \(note.range)")
            print("Time Out (s): \(note.timeOut.map { String($0) } ?? "N/A")")
            print("Timecode Out: \(note.timecodeOut ?? "N/A")")
            print("Frame Out: \(note.frameOut.map { String($0) } ?? "N/A")")

            // Optional Note Metadata Attributes
            print("Name: \(note.name ?? "N/A")")
            print("Commenter: \(note.commenter ?? "N/A")")
            print("Color: \(note.color ?? "N/A")")
            print("Color Hex: \(note.colorHex ?? "N/A")")
            print("Category: \(note.category ?? "N/A")")
            print("Track: \(note.track ?? "N/A")")
            print("Complete: \(note.complete)")
            print("Timestamp: \(note.timestamp ?? "N/A")")
            
            // Nested Arrays
            print("\n--- Replies (\(note.replies.count)) ---")
            if note.replies.isEmpty {
                print("No replies found.")
            } else {
                for (index, reply) in note.replies.enumerated() {
                    print("  Reply \(index + 1):")
                    //print("    ID: \(reply.replyId.map { String($0) } ?? "N/A")")
                    print("    Comment: \(reply.comment)")
                    print("    Commenter: \(reply.commenter ?? "N/A")")
                    print("    Timestamp: \(reply.timestamp ?? "N/A")")
                }
            }

            print("\n--- Tags (\(note.tags.count)) ---")
            if note.tags.isEmpty {
                print("No tags found.")
            } else {
                for (index, tag) in note.tags.enumerated() {
                    print("  Tag \(index + 1):")
                    //print("    ID: \(tag.tagId")
                    print("    Name: \(tag.name)")
                    print("    Group: \(tag.group ?? "N/A")")
                }
            }
            print("==============================")
        }
        
    } catch {
        print("\nFATAL ERROR during Reading: \(error)")
    }
    print("\n--- OTRN Read Example End ---")
}
